//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

import "../"

Item {
    id : item

    property bool pressed
    property bool hovered

    signal clicked()

    property UiMenuItem menuItem
    property var        menuButton

    enabled        : menuItem.enabled && menuItem.visible
    visible        : menuItem.visible
    implicitHeight : 32
    implicitWidth  : label.implicitWidth + icon.implicitWidth + 4 * 8;

    onClicked : {
        menuItem.triggered();
        menuButton.close();
    }

    Rectangle {
        id : background

        anchors.fill : parent
        color        : UiColors.getColor(UiColors.White)

        states : [
            State {
                name : "pressed"
                when : item.pressed

                PropertyChanges {
                    target : background
                    color  : UiColors.getColor(UiColors.SelectionGreen)
                }
            },
            State {
                name : "hovered"
                when : item.hovered

                PropertyChanges {
                    target : background
                    color  : UiColors.getColor(UiColors.HoverGreen)
                }
            }
        ]
    }

    UiIcon {
        id : icon

        anchors {
            verticalCenter : parent.verticalCenter
            left           : parent.left
            leftMargin     : 5
        }
        iconName : menuItem.iconName

        states : [
            State {
                name : "disabled"
                when : !item.enabled

                PropertyChanges {
                    target    : icon
                    disabled  : 1
                }
            },
            State {
                name : "pressed"
                when : item.pressed

                PropertyChanges {
                    target    : icon
                    highlight : 1
                }
            }
        ]
    }
    UiText {
        id : label

        anchors {
            left           : icon.right
            leftMargin     : 7
            verticalCenter : parent.verticalCenter
        }
        text      : menuItem.text
        highlight : item.pressed
    }
}

